#############################################################################
# Deterministic model based on Boots, M. and Y. Haraguchi. 1999. 
# The evolution of costly resistance in host-parasite systems. Am. Nat. 153: 359-370
# Coded by D. George and C. Webb May 28, 2008, updated May 13, 2009
#############################################################################
rm(list=ls())
require(odesolve)

### Parameter values ##################################
pars = c(a= 2, b= 0.012, q= 0.003, g= 1, sigma= 0.08)
tInt = seq(0, 2500, by=1) # time steps

LinearCost <- function(t, y, parms){
    #Assign values of y to state variables.
    B <- y[1]
    r <- parms[1]*B + parms[2]
    Xeq <- parms[4]/B
	Yeq <- (r-parms[3]*parms[4]/B) / (B+parms[3])
	Bdot <- parms[5] * (parms[1]-Yeq)
    list(Bdot)
}

output1 = lsoda(c(B=0.4), times=tInt, func= LinearCost, parms= pars)
head(output1)

### Plotting ###########################
plot(tInt, output1[,"B"], "l", lwd=1.5, xlab="Time", ylab="Susceptibility (B)", col="dark red", main="Linear Cost: No Ecology")
