#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "readpde.h"
#include "maxdef.h"

int compiler(char * bob);
void find_rhs_var(char *name,int *in,int *type);

#define PRIME 39
#define CONVAR 0  /* continuum variable */
#define CONPAR 1 /* continuum parameter */
#define CONWGT 2  /* two-d continuum parameter  */

int TuringWeights[MAXCPAR];   /* Stuff for Turing stability analysis  */

int N_TWts;

extern int NFFT;
double evaluate();
double atof();
/* Right-hand sides       */
int *FixCtm[MAXCFIX],*FixScal[MAXSFIX],*RhsScal[MAXSRHS],*RhsCtm[MAXCRHS];
int *AuxCtm[MAXCAUX],*AuxScal[MAXSAUX]; 
int VarExtend=0;
/* RHS strings      */
char *ScalarTxt[MAXSRHS];
char *CtmTxt[MAXCRHS];

/* Indices to right-hand sides    */

int I_fixctm[MAXCFIX],I_varctm[MAXCRHS],I_auxctm[MAXCAUX];
int I_bdryvar[MAXCRHS];
char *EqnList[MAXALLRHS];
int NEqnList;
int NCTM,NSCALAR,NBVAL,FIX_CTM,FIX_SCAL,NUPAR,NUCPAR,AUX_SCAL,AUX_CTM;
extern int NARRAY,MyRGB;
extern int PER_LEN,CURRENT_GRID;
extern double CURRENT_H;
int FastFlag=0;
double DomainSize;
int Method,PeriodFlag,MaxJac,MaxIter;
int Mr,Ml;
int Nout,PlotVar,BufSize,MaxDeriv;
char OutFile[50],BinFile[50];
double Transient;
double DeltaT,Tolerance,DtMin,DtMax,Epsilon;
int RandSeed;
double TFinal,TStart,BOUND;
extern char TimeName[MAXNAMELEN];
char ucvar_names[MAXCRHS][MAXNAMELEN];
char ucpar_names[MAXCPAR][MAXNAMELEN];
char ucaux_names[MAXCAUX][MAXNAMELEN];
char uaux_names[MAXSAUX][MAXNAMELEN];
char uvar_names[MAXSRHS][MAXNAMELEN];
char upar_names[MAXUPAR][MAXNAMELEN];
char plotvarstring[MAXNAMELEN];
double default_val[MAXUPAR];

extern double *last_ic;
char *get_first(char *string, const char *src);
char *get_next(char *src);

void take_apart(char * bob, double * value, char * name);

void load_eqn(char * filename) {
  FILE *fp;
  char line[STRBUFLEN];
  int flag,ip;
  init_reader();
  fp=fopen(filename,"r");
  if(fp==NULL){
    fprintf(stderr,"%s not found ! \n",filename);
    exit(0);
  }
  while(1){
    fgets(line,MAXSTRLEN,fp);
    if((flag=compiler(line)))break;
  }
  fclose(fp);
  realloc_ctm(CURRENT_GRID);
  if(init_cvars()){
    fprintf(stderr,"Failed to initialize ctm vars\n");
    exit(0);
  }
  if(init_cpars()){
    fprintf(stderr,"Failed to initialize ctm pars\n");
    exit(0);
  }
  Ml=MaxDeriv*NCTM-1;
  Mr=Ml;
  get_plot_name(plotvarstring,&ip);
  PlotVar=-1;
  if(ip>=NSCALAR)PlotVar=ip;
  else if(NCTM>=0)PlotVar=NSCALAR;
  fprintf(stdout,"plot variable set to %d \n",PlotVar);
}



int init_cvars(void) {
  int i;
  for(i=0;i<NCTM;i++)
    if(init_ctm(ucvar_names[i])){
      fprintf(stderr,"Problem with  %s \n",ucvar_names[i]);
      return(1);
    }
  return(0);
}

int init_cpars(void) {
  int i;
  for(i=0;i<NUCPAR;i++)
    if(init_ctm(ucpar_names[i])){
      fprintf(stderr,"Problem with  %s \n",ucpar_names[i]);
      return(1);
    }
  return(0);
}


int init_reader(void) {
  init_rpn();
  init_turing();
  N_TWts=0;
  NCTM=0;
  NFFT=0;
  NSCALAR=0;
  NUPAR=0;
  NUCPAR=0;
  FIX_SCAL=0;
  FIX_CTM=0;
  NBVAL=0;
  CURRENT_GRID=25;
  CURRENT_H=.04;
  MaxDeriv=2;
  NEqnList=0;
  VarExtend=0;
  DomainSize=1.0; 
  DeltaT=.001;
  MyRGB=0;
  BOUND=100.0;
  RandSeed=1;
  TFinal=.01;
  TStart=0.0;
  Method=0;
  FastFlag=0;
  PeriodFlag=0;
  Transient=0.0;
  DtMin=1.e-8;
  DtMax=1.0;
  Tolerance=1.e-4;
  Epsilon=1.e-4;
  MaxIter=20;
  MaxJac=20;
  Nout=100;
  PlotVar=0;
  strcpy(OutFile,"xtc.dat");
  strcpy(BinFile,"xtc.bin");
  BufSize=250;
  strcpy(plotvarstring,"");
}


int compiler(char * bob) {
  double value;
  int narg,done,nn,iflg=0,l,flag;
  char *ptr,*my_string,*command;
  char *bv[3];
  char myline[STRBUFLEN];
  FILE *fp;
  char name[MAXNAMELEN],formula[STRBUFLEN];
  char temp[20];
  int icmd,in,tempcom[MAXCMD],lentemp,ii,ibval;
  int ibc,iker,iset,ns_rhs=0,nc_rhs=0,iside;
  ptr=bob;
  done=1;
  command=get_first(ptr," ,=");
  get_cmd(command,&icmd);
  switch(icmd) {
  case COMMENT: /* ignore and move on ...   */
    break;
  case DONE: return(1);
  case -1:
    /*  look for the '  */
    l=strlen(command);
    if(command[l-1]!=PRIME)
      return(1);
    find_rhs_var(command,&in,&flag);
    if(in<0||flag>1){
      fprintf(stderr,"%s not a differential equation variable",command); /*  <--- serious error   */
      exit(0);   
    }
    my_string=get_next("=\n");

    fprintf(stdout,"form[%d] of type %d = |%s| \n",in,flag,my_string);
    EqnList[NEqnList]=(char *)malloc(strlen(command)+strlen(my_string)+20);
    sprintf(EqnList[NEqnList],"%s=%s",command,my_string);
    NEqnList++;
    if(flag==0){ /* this is a scalar variable  */       
      ScalarTxt[in]=(char *)malloc(strlen(my_string)+10);
      strcpy(ScalarTxt[in],my_string);
      strncpy(formula,my_string,MAXFORMULALEN);
      if(add_expr(formula,tempcom,&lentemp)){
	fprintf(stderr,"failed to add expr %s\n",formula);
	exit(0);
      }
      RhsScal[in]=(int *)malloc((lentemp+5)*sizeof(int));
      for(ii=0;ii<lentemp;ii++)RhsScal[in][ii]=tempcom[ii];
      ns_rhs++;
      prn_comp(tempcom);
    }
    else{  /* this is ctm rhs   */
      if (in>MAXCRHS) {
	fprintf(stderr,"Too many continuum RHS!\n");
	exit(1);
      }
      CtmTxt[in]=(char *)malloc(strlen(my_string)+10);  /* why +10? */
      strcpy(CtmTxt[in],my_string);
      strncpy(formula,my_string,MAXFORMULALEN);
      if(add_expr(formula,tempcom,&lentemp)){
	fprintf(stderr,"failed to add expression %s\n",formula);
	exit(0);
      }
      RhsCtm[in]=(int *)malloc((lentemp+5)*sizeof(int));
      for(ii=0;ii<lentemp;ii++)RhsCtm[in][ii]=tempcom[ii];
      prn_comp(tempcom);
      nc_rhs++;
    }
    return(0); /* ??? */
	
  case TIME: my_string=get_next("$\n");
    strcpy(TimeName,my_string);
    add_var(my_string,0.0);

    fprintf(stdout,"time variable is |%s| \n",my_string);
    break;
  case SPACE: my_string=get_next("$\n");
    fprintf(stdout,"space variable is |%s| \n",my_string);
    create_space_variables(my_string);
    break;

  case PAR:
    fprintf(stdout,"Parameters:\n");
    while((my_string=get_next(" ,\n"))!=NULL)
      {
	take_apart(my_string,&value,name);
	default_val[NUPAR]=value;  
	strncpy(upar_names[NUPAR++],name,MAXNAMELEN);
	fprintf(stdout,"|%s|=%f ",name,value);
	if(add_con(name,value)){
	  fprintf(stderr,"Failed to add constant %s=%f\n",name,value);
	  exit(0); 
	}
      }
    fprintf(stdout,"\n");
    break; 

  case WEIGHT:  
  case CPAR:
    my_string=get_next(" ");
    get_kertype(my_string,&iker);
    fprintf(stdout," type = %d \n",iker);
    my_string=get_next("=");
    fprintf(stdout,"name = |%s| \n",my_string);
    strncpy(ucpar_names[NUCPAR],my_string,MAXNAMELEN);
    NUCPAR++;
    my_string=get_next("$\n");
    fprintf(stdout,"formula=|%s|\n",my_string);
    /* add the ctm  */
    if(icmd==CPAR){
      if(add_ctm_var(ucpar_names[NUCPAR-1],my_string,CONPAR))
	{
	  fprintf(stderr,"Failed to add CVAR %s\n",my_string);exit(0);
	}
      set_ker(ucpar_names[NUCPAR-1],iker);
      if(iker==READFILE)set_ker(ucpar_names[NUCPAR-1],5);
      if(iker==PERNORM){
	TuringWeights[N_TWts]=NARRAY-1;
	N_TWts++;
	fprintf(stdout,"Regarding %s as convolution kernel ind=%d \n",
	       ucpar_names[NUCPAR-1],NARRAY-1);
      }
      if(iker==NORMAL){
	TuringWeights[N_TWts]=NARRAY-1;
	N_TWts++;
	fprintf(stdout,"Regarding %s as averaged  kernel ind=%d \n",
	       ucpar_names[NUCPAR-1],NARRAY-1);
      }
     
     
    }
    else {
      if(add_ctm_var(ucpar_names[NUCPAR-1],my_string,CONWGT)){
	fprintf(stderr,"Failed to add array %s\n",my_string);exit(0);
	
      }
      if(iker==NORMAL)set_ker(ucpar_names[NUCPAR-1],4);
      if(iker==READFILE)set_ker(ucpar_names[NUCPAR-1],5);
	
    }
	
    break; 

  case LOAD:
    my_string=get_next("\n!");
    fprintf(stdout,"loading <%s>\n",my_string);
    if((fp=fopen(my_string,"r"))==NULL)
      {
	fprintf(stderr,"Failed to open file %s \n",my_string);
	exit(0);
      }
    else 
      {
	while(!feof(fp)){
	  fgets(myline,256,fp);
	  if((flag=compiler(myline)))break;
	}
	fclose(fp);
      }
    break;

  case SET:
    my_string=get_next("=");
   
    get_set(my_string,&iset);
    my_string=get_next("$\n");
    fprintf(stdout,"parameter[%d]=<%s>\n",iset,my_string);
    set_special(iset,my_string);
    break;


  case VAR:
    fprintf(stdout,"\nVariables:\n");
    while((my_string=get_next(" ,\n"))!=NULL){
      take_apart(my_string,&value,name);
      if(add_var(name,value)){
     	fprintf(stderr,"Failed to add variable %s=%f",name,value); exit(0);} 
      strncpy(uvar_names[NSCALAR],name,MAXNAMELEN);
      /*	     last_ic[IN_VARS]=value;   */
      NSCALAR++;
      fprintf(stdout,"|%s| ",name);
    }
    fprintf(stdout," \n");
    break;
  case AUX:
    my_string=get_next("=");
    strncpy(name,my_string,MAXNAMELEN);
    my_string=get_next("$\n");
    strncpy(formula,my_string,MAXNAMELEN);
    fprintf(stdout,"|%s| = <%s> \n",name,my_string);
    EqnList[NEqnList]=(char *)malloc(strlen(name)+strlen(my_string)+10);
    sprintf(EqnList[NEqnList],"%s=%s",name,my_string);
    NEqnList++;
    /* compile de sucka */
    strncpy(uaux_names[AUX_SCAL],name,MAXNAMELEN);
    if(add_expr(formula,tempcom,&lentemp)){
      fprintf(stderr,"Failed to compile expression %s\n",formula);
      exit(0);
    }
    prn_comp(tempcom);
    AuxScal[AUX_SCAL]=(int *)malloc((lentemp+5)*sizeof(int));
    for(ii=0;ii<lentemp;ii++)AuxScal[AUX_SCAL][ii]=tempcom[ii];
    AUX_SCAL++;
    break;
 	
  case CAUX:
    my_string=get_next("=");
    strncpy(name,my_string,MAXNAMELEN);
    my_string=get_next("$\n");
    strncpy(formula,my_string,MAXFORMULALEN);
    fprintf(stdout,"|%s| = <%s> \n",name,my_string);
    EqnList[NEqnList]=(char *)malloc(strlen(name)+strlen(my_string)+10);
    sprintf(EqnList[NEqnList],"%s=%s",name,my_string);
    NEqnList++;
    /* make an array and compile de sucka */
    if(add_ctm_var(name,formula,CONVAR)){
      fprintf(stderr,"Failed to add ctm %s\n",formula);exit(0);
    }
    strncpy(ucaux_names[AUX_CTM],name,MAXNAMELEN);
    if(add_expr(formula,tempcom,&lentemp)){
      fprintf(stderr,"Failed to compile..%s\n",formula);
      exit(0);
    }
    AuxCtm[AUX_CTM]=(int *)malloc((lentemp+5)*sizeof(int));
    for(ii=0;ii<lentemp;ii++)AuxCtm[AUX_CTM][ii]=tempcom[ii];
    I_auxctm[AUX_CTM]=NARRAY-1;
    prn_comp(tempcom);
    AUX_CTM++;
    break;
 	

  case FIX:
    my_string=get_next("=");
    strncpy(name,my_string,MAXNAMELEN);
    my_string=get_next("$\n");
    strncpy(formula,my_string,MAXFORMULALEN);
    fprintf(stdout,"|%s| = <%s> \n",name,my_string);
    /* add name and compile de sucka */
    if(add_var(name,0.0)){
      fprintf(stderr,"Failed to add name %s=%f\n",name,value);
      exit(0);
    }
    if(add_expr(formula,tempcom,&lentemp)){
      fprintf(stderr,"Failed to compile..%s\n",formula);
      exit(0);
    }
    FixScal[FIX_SCAL]=(int *)malloc((lentemp+5)*sizeof(int));
    for(ii=0;ii<lentemp;ii++)FixScal[FIX_SCAL][ii]=tempcom[ii];
    FIX_SCAL++;
    prn_comp(tempcom);
    break;
 	
	
  case CFIX: 
    if (FIX_CTM>(MAXCFIX-1)) {
      fprintf(stderr,"Too many fixed continua!\n");
      exit(1);
    }
    my_string=get_next("=");
    strncpy(name,my_string,MAXNAMELEN);
    fprintf(stdout,"|%s| = ",my_string);
    my_string=get_next("$\n");
    fprintf(stdout,"<%s>\n",my_string);
    strncpy(formula,my_string,MAXFORMULALEN);
    /* add name and compile */
    if(add_ctm_var(name,my_string,CONVAR)){
      fprintf(stderr,"Failed to add ctm..%s\n",formula);
      exit(0);
    }
    I_fixctm[FIX_CTM]=NARRAY-1;
    if(add_expr(formula,tempcom,&lentemp)){
      fprintf(stderr,"failed to compile...%s\n",formula);
      exit(0);
    }
    FixCtm[FIX_CTM]=(int *)malloc((lentemp+5)*sizeof(int));
    for(ii=0;ii<lentemp;ii++)FixCtm[FIX_CTM][ii]=tempcom[ii];
    FIX_CTM++;
    prn_comp(tempcom);
    break;
	
	
  case CVAR:
    my_string=get_next("=");
    strcpy(ucvar_names[NCTM],my_string);
    fprintf(stdout,"|%s| = ",my_string);
    my_string=get_next("$\n");
    fprintf(stdout,"<%s>\n",my_string);

    /* add name    */
    if(add_ctm_var(ucvar_names[NCTM],my_string,CONVAR)){
      fprintf(stderr,"failed to add ctm...%s\n",my_string);
      exit(0);
    }
    /* set_ker contains a hack to avoid overwriting "special" flag;
     * need something better */
    set_ker(ucvar_names[NCTM],VarExtend);
    I_varctm[NCTM]=NARRAY-1;
    if(NCTM==0&&strlen(plotvarstring)==0)
      strncpy(plotvarstring,ucvar_names[NCTM],MAXNAMELEN);
    NCTM++;
    break;

  case FUN: 
    my_string=get_next(" ");
    strncpy(name,my_string,MAXNAMELEN);
    my_string=get_next(" ");
    narg=atoi(my_string);
    my_string=get_next("$\n");
    strncpy(formula,my_string,MAXFORMULALEN);
    fprintf(stdout,"FUN %s(#%d) = |%s|\n",name,narg,formula);
    if(add_ufun(name,formula,narg)){
      fprintf(stderr,"Bad user function");
      exit(0); 
    }

    break;
  case BDRY:
    my_string=get_next(" ");
    strncpy(name,my_string,MAXNAMELEN);
    my_string=get_next(" ");
    iside=atoi(my_string);
    my_string=get_next("{");
    get_bctype(my_string,&ibc);
    fprintf(stdout," name=%s side =%d \n",name,iside);
    if(ibc==PERIODIC)PeriodFlag=1;
    if(ibc==LEAKY||ibc==DYNAMIC){
      my_string=get_next("}");
      bv[0]=my_string;
   
      my_string=get_next("{");
      my_string=get_next("}");
      bv[1]=my_string;

      my_string=get_next("{");
      my_string=get_next("}");
      bv[2]=my_string;
      fprintf(stdout," %s %s %s \n",bv[0],bv[1],bv[2]);
    }
    else {
      fprintf(stdout," bc is %d \n",ibc);
    }
    find_rhs_var(name,&in,&flag);
    if(flag!=1){
      fprintf(stderr,"Not a continuum variable!");
      exit(0);
    }
   
    add_deriv(name,bv,ibc,iside,&ibval);
    I_bdryvar[ibval]=in;
    fprintf(stdout," %d bdry associated with %d \n",ibval,in);
    break;
 
  }

 
  if(icmd==DONE)return(1);
  return(0);

}  



int prn_comp(int * command) {
  int debug=0;
  int i=0;
  if (debug) {
    while(command[i]!=999)
      fprintf(stdout," %d \n",command[i++]);
  }
  return;
}

set_plot_name(name,in)
     int in;
     char *name;
{
  if(in<0){strcpy(name,""); return(1);}
  if(in<NSCALAR){ strncpy(name,uvar_names[in],MAXNAMELEN); return(0);}
  if(in<(NSCALAR+NCTM)){strncpy(name,ucvar_names[in-NSCALAR],MAXNAMELEN);return(0);}
  if(in<(NSCALAR+NCTM+AUX_SCAL)){
    strncpy(name,uaux_names[in-NSCALAR-NCTM],MAXNAMELEN);
    return(0);
  }
  if(in<(NSCALAR+NCTM+AUX_SCAL+AUX_CTM)){
    strncpy(name,ucaux_names[in-NSCALAR-NCTM-AUX_SCAL],MAXNAMELEN);
    return(0);
  }
  strcpy(name,"");
  return(1);
} 

get_plot_name(name,in)
     char *name;
     int *in;
{
  int type=-1;
  find_rhs_var(name,in,&type);
  if(type==-1||*in<0)return;
  switch(type){
  case 0:
    return;
  case 1:
    *in=*in+NSCALAR;
    return;
  case 2:
    *in=*in+NSCALAR+NCTM;
    return;
  case 3:
    *in=*in+NSCALAR+NCTM+AUX_SCAL;
    return;
  }

}
  
void find_rhs_var(char *name,int *in,int *type)
{
  int i,len=0,l;
  *type=0;
  *in=-1;
  for(i=0;i<NSCALAR;i++){
    l=strlen(uvar_names[i]);
    if(strncasecmp(name,uvar_names[i],l)==0){
      if(l>len){
	len=l;
	*in=i;
	*type=0;
      }
    }
  }
  for(i=0;i<NCTM;i++){
    l=strlen(ucvar_names[i]);
    if(strncasecmp(name,ucvar_names[i],l)==0){
      if(l>len){
	len=l;
	*in=i;
	*type=1;
      }
    }
  } 
  for(i=0;i<AUX_SCAL;i++){
    l=strlen(uaux_names[i]);
    if(strncasecmp(name,uaux_names[i],l)==0){
      if(l>len){
	len=l;
	*in=i;
	*type=2;
      }
    }
  }
  for(i=0;i<AUX_CTM;i++){
    l=strlen(ucaux_names[i]);
    if(strncasecmp(name,ucaux_names[i],l)==0){
      if(l>len){
	len=l;
	*in=i;
	*type=3;
      }
    }
  }
}


void get_vocab(char *command,int *icmd,VOCAB *vocab,int length) {
  int i;
  *icmd=-1;
  for(i=0;i<length;i++){
    if(strncasecmp(command,(vocab+i)->name,(vocab+i)->len)==0){
      *icmd=i;
      return;
    }
  }
}
 
int set_special(int i,char *s) {
  int ip;
  switch(i){
  case NPERIOD:
    PER_LEN=atoi(s);
    break;
  case LENGTH:
    DomainSize=atof(s);
    CURRENT_H=DomainSize/CURRENT_GRID;
    break;
  case GRID:
    CURRENT_GRID=atoi(s);
    CURRENT_H=DomainSize/CURRENT_GRID;
    break;
  case FAST:
    FastFlag=atoi(s);
    break;
  case METHOD:
    Method=atoi(s);
    if(Method<0||Method>3)Method=0;
    break;
  case DELTA_T:
    DeltaT=atof(s);
    break;
  case TFINAL:
    TFinal=atof(s);
    break;
  case TRANS:
    Transient=atof(s);
    break;
  case NOUT:
    Nout=atoi(s);
    fprintf(stdout,"Nout set to %d \n",Nout);
    break;
  case PLOTVAR:
    strcpy(plotvarstring,s);
    break;
  case EXTEND:
    VarExtend=atoi(s);
    break;
  case RGB:
    MyRGB=atoi(s);
    break;
  case BUFSIZE:
    BufSize=atoi(s);
    break;
  case DTMIN:
    DtMin=atof(s);
    break;
  case DTMAX:
    DtMax=atof(s);
    break;
  case TOLERANCE:
    Tolerance=atof(s);
    break;
  case EPSILON:
    Epsilon=atof(s);
    break;
  case JACUSE:
    MaxJac=atoi(s);
    break;
  case MAXITER:
    MaxIter=atoi(s);
    break;
  case TSTART:
    TStart=atof(s);
    break;
  case MAXDERIV:
    MaxDeriv=atoi(s);
    break;
  case BOUNDSET:
    BOUND=atof(s);
    if(BOUND<=0.0)BOUND=100.0;
    break;
  case SEED:
    RandSeed=atoi(s);
    break;
  }
}

int get_set(char *command,int *icmd) {
  get_vocab(command,icmd,my_set,NSET);
}

int get_bctype(char *command,int *icmd) {
  get_vocab(command,icmd,my_bcs,NBCS);
}

int get_kertype(char *command,int *icmd) {
  get_vocab(command,icmd,my_ker,NKER);
}

int get_cmd(char *command, int *icmd) {
  get_vocab(command,icmd,my_cmd,NCMD);
}
 

void take_apart(char * bob, double * value, char * name) {
  int k,i,l;
  char number[40];
  l=strlen(bob);
  k=strcspn(bob,"=");
  if(k==l)
    {
      *value=0.0;
      strcpy(name,bob);
    }
  else
    {
      strncpy(name,bob,k);
      name[k]='\0';
      for(i=k+1;i<l;i++)number[i-k-1]=bob[i];
      number[l-k-1]='\0';
      *value=atof(number);
    }
}

char *get_first(char *string, const char *src) {
  char *ptr;
  ptr=strtok(string,src);
  return(ptr);
}

char *get_next(char * src) {
  char *ptr;
  ptr=strtok(NULL,src);
  return(ptr);
}




